/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.schedops.schedulables;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Command {
    protected boolean stderrClosed;
    protected boolean stdoutClosed;
    protected StringBuffer stderrOutput;
    protected StringBuffer stdoutOutput;
    protected String[] command;

    public Command(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid null command");
        }
        this.command = new String[]{"/bin/sh", "-c", string};
    }

    public Command(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Invalid null command");
        }
        this.command = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int n = -1;
        try {
            final Process process = Runtime.getRuntime().exec(this.command);
            this.stderrClosed = false;
            this.stdoutClosed = false;
            this.stderrOutput = null;
            this.stdoutOutput = null;
            new Thread(new Runnable(){

                public void run() {
                    Command.this.readFromStderr(process);
                }
            }, "Read from command stderr").start();
            new Thread(new Runnable(){

                public void run() {
                    Command.this.readFromStdout(process);
                }
            }, "Read from command stdout").start();
            n = process.waitFor();
            Command command = this;
            synchronized (command) {
                while (!this.stdoutClosed || !this.stderrClosed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n;
    }

    public String getStderr() {
        return this.stderrOutput == null ? null : this.stderrOutput.toString();
    }

    public String getStdout() {
        return this.stdoutOutput == null ? null : this.stdoutOutput.toString();
    }

    protected StringBuffer readFromStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        char[] cArray = new char[100];
        boolean bl = false;
        StringBuffer stringBuffer = null;
        try {
            while (!bl) {
                int n = bufferedReader.read(cArray);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            bl = true;
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromStderr(Process process) {
        StringBuffer stringBuffer = this.readFromStream(process.getErrorStream());
        Command command = this;
        synchronized (command) {
            this.stderrClosed = true;
            this.stderrOutput = stringBuffer;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromStdout(Process process) {
        StringBuffer stringBuffer = this.readFromStream(process.getInputStream());
        Command command = this;
        synchronized (command) {
            this.stdoutClosed = true;
            this.stdoutOutput = stringBuffer;
            this.notifyAll();
        }
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        Command command = new Command(stringBuffer.toString());
        System.out.println("\nRC = " + command.execute() + "\n");
        System.out.println("********** STDERR **********");
        System.out.println(command.getStderr());
        System.out.println("********** STDOUT **********");
        System.out.println(command.getStdout());
    }
}

